<?php

namespace App\Http\Controllers\Admin\OnlineExam;

use Exception;
use DataTables;
use App\SmClass;
use App\SmStaff;
use App\SmParent;
use App\SmSection;
use App\SmStudent;
use App\SmSubject;
use Carbon\Carbon;
use App\SmOnlineExam;
use App\Models\Shift;
use App\SmNotification;
use App\SmQuestionBank;
use App\SmAssignSubject;
use App\SmOnlineExamMark;
use App\SmGeneralSettings;
use Illuminate\Http\Request;
use App\Models\StudentRecord;
use App\SmOnlineExamQuestion;
use App\SmStudentTakeOnlineExam;
use App\Traits\NotificationSend;
use Illuminate\Support\Facades\DB;
use App\SmOnlineExamQuestionAssign;
use App\Http\Controllers\Controller;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Support\Facades\Auth;
use App\SmOnlineExamQuestionMuOption;
use Illuminate\Support\Facades\Schema;
use App\OnlineExamStudentAnswerMarking;
use Modules\OnlineExam\Entities\InfixOnlineExam;
use App\Http\Requests\Admin\OnlineExam\SmOnlineExamRequest;
use Modules\OnlineExam\Entities\InfixStudentTakeOnlineExam;
use App\Http\Controllers\Admin\StudentInfo\SmStudentReportController;

class SmOnlineExamController extends Controller
{
    use NotificationSend;

    private $timeZone;

    public function __construct()
    {
        $this->timeZone = generalSetting()->timeZone->time_zone ?? 'Asia/Dhaka';
    }

    public function index()
    {
        $time_zone_setup = SmGeneralSettings::join('sm_time_zones', 'sm_time_zones.id', '=', 'sm_general_settings.time_zone_id')
            ->where('school_id', Auth::user()->school_id)->first();
        date_default_timezone_set($time_zone_setup->time_zone);
        /*
        try {
        */
        if (! Schema::hasColumn('sm_online_exams', 'auto_mark')) {
            Schema::table('sm_online_exams', function ($table): void {
                $table->integer('auto_mark')->default(0);
            });
        }

        if (teacherAccess()) {
            $teacher_info = SmStaff::where('user_id', Auth::user()->id)->first();
            $online_exams = SmOnlineExam::where('status', '!=', 2)
                ->join('sm_assign_subjects', 'sm_assign_subjects.subject_id', '=', 'sm_online_exams.subject_id')
                ->where('sm_assign_subjects.teacher_id', $teacher_info->id)
                ->where('sm_online_exams.academic_id', getAcademicId())
                ->where('sm_online_exams.school_id', Auth::user()->school_id)
                ->select('sm_online_exams.*')
                ->distinct('id')
                ->get();
            $classes = $teacher_info->classes;
        } else {
            $classes = SmClass::get();
            $online_exams = SmOnlineExam::with('class', 'section', 'subject')->where('status', '!=', 2)->get();
        }

        $sections = SmSection::get();
        $subjects = SmSubject::get();
        $present_date_time = date('Y-m-d H:i:s');
        $present_time = date('H:i:s');

        return view('backEnd.examination.online_exam', ['online_exams' => $online_exams, 'classes' => $classes, 'sections' => $sections, 'subjects' => $subjects, 'present_date_time' => $present_date_time, 'present_time' => $present_time]);
        /*
        } catch (Exception $exception) {
            Toastr::error('Operation Failed', 'Failed');

            return redirect()->back();
        }
        */
    }

    public function viewOnlineExam($id)
    {
        /*
        try {
        */
        $online_exam = SmOnlineExam::find($id);
        $assigned_questions = SmOnlineExamQuestionAssign::where('online_exam_id', $online_exam->id)
            ->where('academic_id', getAcademicId())
            ->where('school_id', Auth::user()->school_id)
            ->get();

        return view('backEnd.examination.view_online_question', ['online_exam' => $online_exam, 'assigned_questions' => $assigned_questions]);
        /*
        } catch (Exception $exception) {
            Toastr::error('Operation Failed', 'Failed');

            return redirect()->back();
        }
        */
    }

    public function universityOnlineExamStore($request)
    {
        DB::beginTransaction();
        try {
            foreach ($request->un_section_ids as $section) {
                $online_exam = new SmOnlineExam();
                $online_exam->title = $request->title;
                $online_exam->un_session_id = $request->un_session_id;
                $online_exam->un_faculty_id = $request->un_faculty_id;
                $online_exam->un_department_id = $request->un_department_id;
                $online_exam->un_semester_label_id = $request->un_semester_label_id;
                $online_exam->un_section_id = $section;
                $online_exam->un_subject_id = $request->un_subject_id;
                $online_exam->date = date('Y-m-d', strtotime($request->date));
                $online_exam->start_time = date('H:i:s', strtotime($request->start_time));
                $online_exam->end_time = date('H:i:s', strtotime($request->end_time));
                $online_exam->end_date_time = date('Y-m-d H:i:s', strtotime($request->date.' '.$request->end_time));
                $online_exam->percentage = $request->percentage;
                $online_exam->instruction = $request->instruction;
                $online_exam->status = 0;
                if ($request->auto_mark) {
                    $online_exam->auto_mark = $request->auto_mark;
                }

                $online_exam->school_id = Auth::user()->school_id;
                $online_exam->un_academic_id = getAcademicId();
                $online_exam->save();

                $data['un_semester_label_id'] = $online_exam->un_semester_label_id;
                $data['un_section_id'] = $online_exam->un_section_id;
                $data['subject'] = $online_exam->subject->subject_name;
                $records = $this->unStudentRecordInfo($request->un_semester_label_id, $section)->pluck('studentDetail.user_id');
                $this->sent_notifications('Online_Exam_Publish', $records, $data, ['Student', 'Parent']);
            }

            DB::commit();

            Toastr::success('Operation successful', 'Success');

            return redirect()->back();
        } catch (Exception $exception) {
            DB::rollBack();
            Toastr::error('Operation Failed', 'Failed');

            return redirect()->back();
        }
    }

    public function store(SmOnlineExamRequest $smOnlineExamRequest)
    {
        if (moduleStatusCheck('University')) {
            return $this->universityOnlineExamStore($smOnlineExamRequest);
        }

        DB::beginTransaction();
        try {
            foreach ($smOnlineExamRequest->section as $section) {
                $online_exam = new SmOnlineExam();
                $online_exam->title = $smOnlineExamRequest->title;
                $online_exam->class_id = $smOnlineExamRequest->class;
                $online_exam->shift_id = shiftEnable() ? $smOnlineExamRequest->shift : '';
                $online_exam->section_id = $section;
                $online_exam->subject_id = $smOnlineExamRequest->subject;
                $online_exam->date = date('Y-m-d', strtotime($smOnlineExamRequest->date));
                $online_exam->start_time = date('H:i:s', strtotime($smOnlineExamRequest->start_time));
                $online_exam->end_time = date('H:i:s', strtotime($smOnlineExamRequest->end_time));
                $online_exam->end_date_time = date('Y-m-d H:i:s', strtotime($smOnlineExamRequest->date.' '.$smOnlineExamRequest->end_time));
                $online_exam->percentage = $smOnlineExamRequest->percentage;
                $online_exam->instruction = $smOnlineExamRequest->instruction;
                $online_exam->status = 0;
                if ($smOnlineExamRequest->auto_mark) {
                    $online_exam->auto_mark = $smOnlineExamRequest->auto_mark;
                }

                $online_exam->school_id = Auth::user()->school_id;
                $online_exam->academic_id = getAcademicId();
                $online_exam->save();

                $data['class_id'] = $online_exam->class_id;
                $data['section_id'] = $online_exam->section_id;
                $data['subject'] = $online_exam->subject->subject_name;
                $data['shift_id'] = shiftEnable() ? $online_exam->shift_id : '';
                $shift_id = shiftEnable() ? $smOnlineExamRequest->shift : null;
                $records = $this->studentRecordInfo($smOnlineExamRequest->class, $smOnlineExamRequest->section, $shift_id)
                    ->pluck('studentDetail.user_id');
                $this->sent_notifications('Online_Exam_Publish', $records, $data, ['Student', 'Parent']);
            }

            DB::commit();

            Toastr::success('Operation successful', 'Success');

            return redirect()->back();
        } catch (Exception $exception) {
            Toastr::error('Operation Failed', 'Failed');

            return redirect()->back();
        }

    }

    public function edit($id)
    {
        $time_zone_setup = SmGeneralSettings::with('timeZone')->where('school_id', Auth::user()->school_id)
            ->first();
        date_default_timezone_set(@$time_zone_setup->timeZone->time_zone);
        /*
        try {
        */
        $online_exams = SmOnlineExam::where('school_id', Auth::user()->school_id)->get();
        $online_exam = SmOnlineExam::find($id);
        if (teacherAccess()) {
            $teacher_info = SmStaff::where('user_id', Auth::user()->id)->first();
            $classes = $teacher_info->classes;
        } else {
            $classes = SmClass::get();
        }

        $sections = SmAssignSubject::where('class_id', $online_exam->class_id)->where('subject_id', $online_exam->subject_id)->get();
        $subjects = SmAssignSubject::where('class_id', $online_exam->class_id)->where('section_id', $online_exam->section_id)->select('subject_id')->distinct('subject_id')->get();
        $present_date_time = date('Y-m-d H:i:s');
        $present_time = date('H:i:s');

        $editData = null;
        if (moduleStatusCheck('University')) {
            $editData = $online_exam;
        }

        return view('backEnd.examination.online_exam', ['online_exams' => $online_exams, 'classes' => $classes, 'sections' => $sections, 'subjects' => $subjects, 'online_exam' => $online_exam, 'present_date_time' => $present_date_time, 'present_time' => $present_time, 'editData' => $editData]);
        /*
        } catch (Exception $exception) {
            Toastr::error('Operation Failed', 'Failed');

            return redirect()->back();
        }
        */
    }

    public function universityUpdate($request, $id)
    {
        /*
        try {
        */
        $online_exam = SmOnlineExam::find($id);
        $online_exam->title = $request->title;
        $online_exam->un_session_id = $request->un_session_id;
        $online_exam->un_faculty_id = $request->un_faculty_id;
        $online_exam->un_department_id = $request->un_department_id;
        $online_exam->un_semester_label_id = $request->un_semester_label_id;
        $online_exam->un_section_id = $request->un_section_id;
        $online_exam->un_subject_id = $request->un_subject_id;

        $online_exam->date = date('Y-m-d', strtotime($request->date));
        $online_exam->start_time = date('H:i:s', strtotime($request->start_time));
        $online_exam->end_time = date('H:i:s', strtotime($request->end_time));
        $online_exam->end_date_time = date('Y-m-d H:i:s', strtotime($request->end_date.' '.$request->end_time));
        $online_exam->percentage = $request->percentage;
        $online_exam->instruction = $request->instruction;
        if ($request->auto_mark) {
            $online_exam->auto_mark = $request->auto_mark;
        }

        $online_exam->save();
        Toastr::success('Operation successful', 'Success');

        return redirect('online-exam');
        /*
        } catch (Exception $exception) {
            Toastr::error('Operation Failed', 'Failed');

            return redirect()->back();
        }
        */
    }

    public function update(SmOnlineExamRequest $smOnlineExamRequest, $id)
    {
        if (moduleStatusCheck('University')) {
            return $this->universityUpdate($smOnlineExamRequest, $id);
        }
        /*
        try {
        */
        $online_exam = SmOnlineExam::find($id);
        $online_exam->title = $smOnlineExamRequest->title;
        if(shiftEnable())
        {
            $online_exam->shift_id = shiftEnable() ? $smOnlineExamRequest->shift : '';
        }
        $online_exam->class_id = $smOnlineExamRequest->class;
        $online_exam->section_id = $smOnlineExamRequest->section;
        $online_exam->subject_id = $smOnlineExamRequest->subject;
        $online_exam->date = date('Y-m-d', strtotime($smOnlineExamRequest->date));
        $online_exam->start_time = date('H:i:s', strtotime($smOnlineExamRequest->start_time));
        $online_exam->end_time = date('H:i:s', strtotime($smOnlineExamRequest->end_time));
        $online_exam->end_date_time = date('Y-m-d H:i:s', strtotime($smOnlineExamRequest->end_date.' '.$smOnlineExamRequest->end_time));
        $online_exam->percentage = $smOnlineExamRequest->percentage;
        $online_exam->instruction = $smOnlineExamRequest->instruction;
        if ($smOnlineExamRequest->auto_mark) {
            $online_exam->auto_mark = $smOnlineExamRequest->auto_mark;
        }

        $online_exam->save();
        Toastr::success('Operation successful', 'Success');

        return redirect('online-exam');
        /*
        } catch (Exception $exception) {
            Toastr::error('Operation Failed', 'Failed');

            return redirect()->back();
        }
        */

    }

    public function section()
    {
        /*
        try {
        */
        $id = $_GET['id'];

        return response()->json(['response' => 'This is get method']);
        /*
        } catch (Exception $exception) {
            Toastr::error('Operation Failed', 'Failed');

            return redirect()->back();
        }
        */
    }

    public function delete(Request $request)
    {
        /*
        try {
        */
        $id_key = 'online_exam_id';
        $id = $request->online_exam_id;
        $tables = \App\tableList::getTableList($id_key, $id);
        /*
        try {
        */
        if (empty($tables)) {
            $delete_query = SmOnlineExam::findOrFail($request->online_exam_id);
            if ($delete_query) {
                $delete_query->delete();
            }

            Toastr::success('Operation successful', 'Success');

            return redirect()->back();
        }
        $msg = 'This data already used in  : '.$tables.' Please remove those data first';
        Toastr::error($msg, 'Failed');

        return redirect()->back();

        /*
        } catch (\Illuminate\Database\QueryException $e) {
            $msg = 'This data already used in  : '.$tables.' Please remove those data first';
            Toastr::error($msg, 'Failed');

            return redirect()->back();
        }
        } catch (Exception $exception) {
        Toastr::error('Operation Failed', 'Failed');

        return redirect()->back();
        }
        */
    }

    public function manageOnlineExamQuestion($id)
    {
        /*
        try {
        */
        $online_exam = SmOnlineExam::find($id);
        $question_banks = SmQuestionBank::with('questionGroup')->where('class_id', $online_exam->class_id)
            ->where('section_id', $online_exam->section_id)
            ->get();
        $already_assigned = SmOnlineExamQuestionAssign::where('online_exam_id', $id)
            ->pluck('question_bank_id')
            ->toArray();

        return view('backEnd.examination.manage_online_exam', ['online_exam' => $online_exam, 'question_banks' => $question_banks, 'already_assigned' => $already_assigned]);
        /*
        } catch (Exception $exception) {
            Toastr::error('Operation Failed', 'Failed');

            return redirect()->back();
        }
        */
    }

    public function manageOnlineExamQuestionStore(Request $request)
    {
        /*
        try {
        */
        if ($request->question_type !== 'M') {
            $online_question = new SmOnlineExamQuestion();
            $online_question->online_exam_id = $request->online_exam_id;
            $online_question->type = $request->question_type;
            $online_question->mark = $request->mark;
            $online_question->title = $request->question_title;
            $online_question->school_id = Auth::user()->school_id;
            $online_question->academic_id = getAcademicId();
            if ($request->question_type == 'F') {
                $online_question->suitable_words = $request->suitable_words;
            } elseif ($request->question_type == 'T') {
                $online_question->trueFalse = $request->trueOrFalse;
            }

            $result = $online_question->save();
            if ($result) {
                Toastr::success('Operation successful', 'Success');

                return redirect()->back();
            }

            Toastr::error('Operation Failed', 'Failed');

            return redirect()->back();

        }

        DB::beginTransaction();
        try {
            $online_question = new SmOnlineExamQuestion();
            $online_question->online_exam_id = $request->online_exam_id;
            $online_question->type = $request->question_type;
            $online_question->mark = $request->mark;
            $online_question->title = $request->question_title;
            $online_question->school_id = Auth::user()->school_id;
            $online_question->academic_id = getAcademicId();
            $online_question->save();
            $online_question->toArray();
            $i = 0;
            if (property_exists($request, 'option') && $request->option !== null) {
                foreach ($request->option as $option) {
                    $i++;
                    $option_check = 'option_check_'.$i;
                    $online_question_option = new SmOnlineExamQuestionMuOption();
                    $online_question_option->online_exam_question_id = $online_question->id;
                    $online_question_option->title = $option;
                    $online_question_option->school_id = Auth::user()->school_id;
                    $online_question_option->academic_id = getAcademicId();
                    $online_question_option->status = isset($request->$option_check) ? 1 : 0;
                    $online_question_option->save();
                }
            }

            DB::commit();
            Toastr::success('Operation successful', 'Success');

            return redirect()->back();
        } catch (Exception $e) {
            DB::rollBack();
        }

        Toastr::error('Operation Failed', 'Failed');

        return redirect()->back();

        /*
        } catch (Exception $exception) {
            Toastr::error('Operation Failed', 'Failed');

            return redirect()->back();
        }
        */
    }

    public function onlineExamPublish($id)
    {
        /*
        try {
        */
        $time_zone_setup = SmGeneralSettings::join('sm_time_zones', 'sm_time_zones.id', '=', 'sm_general_settings.time_zone_id')
            ->where('school_id', Auth::user()->school_id)->first();
        date_default_timezone_set($time_zone_setup->time_zone);
        $present_date_time = date('Y-m-d H:i:s');
        $publish = SmOnlineExam::find($id);
        $class_id = $publish->class_id;
        $section_id = $publish->section_id;
        if ($present_date_time > $publish->end_date_time) {
            Toastr::error('Please update exam time', 'Failed');

            return redirect()->back();
        }

        $publish->status = 1;
        $publish->save();
        $student_ids = StudentRecord::where('class_id', $class_id)
            ->where('section_id', $section_id)
            ->where('is_promote', 0)
            ->where('academic_id', getAcademicId())
            ->where('school_id', Auth::user()->school_id)
            ->pluck('student_id')
            ->unique();

        $students = SmStudent::whereIn('id', $student_ids)
            ->where('class_id', $class_id)
            ->where('section_id', $section_id)
            ->where('academic_id', getAcademicId())
            ->where('school_id', Auth::user()->school_id)
            ->get();

        foreach ($students as $student) {
            $notification = new SmNotification;
            $notification->user_id = $student->user_id;
            $notification->role_id = 2;
            $notification->date = date('Y-m-d');
            $notification->message = 'New online exam published';
            $notification->url = 'student-online-exam';
            $notification->school_id = Auth::user()->school_id;
            $notification->academic_id = getAcademicId();
            $notification->save();

            $parent = SmParent::find($student->parent_id);
            $notidication = new SmNotification();
            $notidication->role_id = 3;
            $notidication->message = 'New online exam published for your child';
            $notidication->date = date('Y-m-d');
            $notidication->user_id = $parent->user_id;
            $notification->school_id = Auth::user()->school_id;
            $notidication->academic_id = getAcademicId();
            $notidication->save();
        }

        Toastr::success('Operation successful', 'Success');

        return redirect()->route('online-exam');
        /*
        } catch (Exception $exception) {
            Toastr::error('Operation Failed', 'Failed');

            return redirect()->back();
        }
        */
    }

    public function onlineExamPublishCancel($id)
    {
        /*
        try {
        */
        $publish = SmOnlineExam::find($id);
        $publish->status = 3;
        $publish->save();
        Toastr::error('Exam Expired', 'Failed');

        return redirect()->back();
        /*
        } catch (Exception $exception) {
            Toastr::error('Operation Failed', 'Failed');

            return redirect()->back();
        }
        */
    }

    public function onlineQuestionEdit($id, $type, $examId)
    {
        /*
        try {
        */
        $online_exam_question = SmOnlineExamQuestion::find($id);

        return view('backEnd.examination.online_exam_question_edit', ['id' => $id, 'type' => $type, 'examId' => $examId, 'online_exam_question' => $online_exam_question]);
        /*
        } catch (Exception $exception) {
            Toastr::error('Operation Failed', 'Failed');

            return redirect()->back();
        }
        */
    }

    public function onlineExamQuestionEdit(Request $request)
    {
        /*
        try {
        */
        if ($request->question_type !== 'M') {
            if (checkAdmin() == true) {
                $online_question = SmOnlineExam::find($request->id);
            } else {
                $online_question = SmOnlineExam::where('id', $request->id)->where('school_id', Auth::user()->school_id)->first();
            }

            $online_question->online_exam_id = $request->online_exam_id;
            $online_question->type = $request->question_type;
            $online_question->mark = $request->mark;
            $online_question->title = $request->question_title;
            if ($request->question_type == 'F') {
                $online_question->suitable_words = $request->suitable_words;
            } elseif ($request->question_type == 'T') {
                $online_question->trueFalse = $request->trueOrFalse;
            }

            $result = $online_question->save();
            if ($result) {
                Toastr::success('Operation successful', 'Success');

                return redirect()->back();
            }

            Toastr::error('Operation Failed', 'Failed');

            return redirect()->back();

        }

        DB::beginTransaction();
        try {
            if (checkAdmin() == true) {
                $online_question = SmOnlineExamQuestion::find($request->id);
            } else {
                $online_question = SmOnlineExamQuestion::where('id', $request->id)->where('school_id', Auth::user()->school_id)->first();
            }

            $online_question->online_exam_id = $request->online_exam_id;
            $online_question->type = $request->question_type;
            $online_question->mark = $request->mark;
            $online_question->title = $request->question_title;
            $online_question->save();
            $online_question->toArray();
            SmOnlineExamQuestionMuOption::where('online_exam_question_id', $online_question->id)->delete();
            $i = 0;
            if (property_exists($request, 'option') && $request->option !== null) {
                foreach ($request->option as $option) {
                    $i++;
                    $option_check = 'option_check_'.$i;
                    $online_question_option = new SmOnlineExamQuestionMuOption();
                    $online_question_option->online_exam_question_id = $online_question->id;
                    $online_question_option->title = $option;
                    $online_question_option->school_id = Auth::user()->school_id;
                    $online_question_option->academic_id = getAcademicId();
                    $online_question_option->status = isset($request->$option_check) ? 1 : 0;
                    $online_question_option->save();
                }
            }

            DB::commit();
            Toastr::success('Operation successful', 'Success');

            return redirect()->back();
        } catch (Exception $e) {
            DB::rollBack();
        }

        Toastr::error('Operation Failed', 'Failed');

        return redirect()->back();

        /*
        } catch (Exception $exception) {
            Toastr::error('Operation Failed', 'Failed');

            return redirect()->back();
        }
        */
    }

    public function onlineExamQuestionDelete(Request $request)
    {
        /*
        try {
        */
        if (checkAdmin() == true) {
            $online_exam_question = SmOnlineExamQuestion::find($request->id);
        } else {
            $online_exam_question = SmOnlineExamQuestion::where('id', $request->id)->where('school_id', Auth::user()->school_id)->first();
        }

        if ($online_exam_question->type == 'M') {
            SmOnlineExamQuestionMuOption::where('online_exam_question_id', $online_exam_question->id)->delete();
            $online_exam_question->delete();
        } else {
            $online_exam_question->delete();
        }

        Toastr::success('Operation successful', 'Success');

        return redirect()->back();
        /*
        } catch (Exception $exception) {
            Toastr::error('Operation Failed', 'Failed');

            return redirect()->back();
        }
        */
    }

    public function onlineExamMarksRegister($id)
    {
        /*
        try {
        */
        $online_exam_question = SmOnlineExam::find($id);
        // return $online_exam_question;
        $studentRecords = StudentRecord::query();

        if (moduleStatusCheck('University')) {
            $studentRecords = $studentRecords->where('un_semester_label_id', $online_exam_question->un_semester_label_id)
                ->where('un_section_id', $online_exam_question->un_section_id);
        } else {
            $studentRecords = $studentRecords->where('class_id', $online_exam_question->class_id)
                ->where('section_id', $online_exam_question->section_id);
        }

        $studentRecords = $studentRecords->where('school_id', Auth::user()->school_id)
            ->where('is_promote', 0)
            ->get();
        $student_ids = $studentRecords->pluck('student_id')->toArray();
        $present_students = [];
        $take_exam = SmStudentTakeOnlineExam::whereIn('student_id', $student_ids)
            ->where('online_exam_id', $online_exam_question->id)
            ->get();
        if ($take_exam !== '') {
            $present_students = $take_exam->pluck('student_id')->toArray();
        }

        return view('backEnd.examination.online_exam_marks_register', ['online_exam_question' => $online_exam_question, 'present_students' => $present_students, 'studentRecords' => $studentRecords]);
        /*
        } catch (Exception $exception) {
            Toastr::error('Operation Failed', 'Failed');

            return redirect()->back();
        }
        */
    }

    public function onlineExamMarksStore(Request $request)
    {
        /*
        try {
        */
        if (checkAdmin() == true) {
            SmOnlineExamMark::where('exam_id', $request->exam_id)->delete();
        } else {
            SmOnlineExamMark::where('exam_id', $request->exam_id)->where('school_id', Auth::user()->school_id)->delete();
        }

        $counter = 0;
        foreach ($request->students as $student) {
            $counter++;
            $marks = 'marks_'.$counter;
            $abs = 'abs_'.$counter;
            $online_mark = new SmOnlineExamMark();
            $online_mark->exam_id = $request->exam_id;
            $online_mark->subject_id = $request->subject_id;
            $online_mark->student_id = $student;
            $online_mark->school_id = Auth::user()->school_id;
            $online_mark->academic_id = getAcademicId();
            if (isset($request->$abs)) {
                $online_mark->abs = $request->$abs;
            } else {
                $online_mark->marks = $request->$marks;
                $online_mark->abs = 0;
            }

            $online_mark->save();
        }

        Toastr::success('Operation successful', 'Success');

        return redirect('online-exam');
        /*
        } catch (Exception $exception) {
            Toastr::error('Operation Failed', 'Failed');

            return redirect()->back();
        }
        */
    }

    public function onlineExamResult($id)
    {
        /*
        try {
        */
        $online_exam_question = SmOnlineExam::find($id);
        $studentRecords = StudentRecord::where('class_id', $online_exam_question->class_id)
            ->where('section_id', $online_exam_question->section_id)
            ->where('is_promote', 0)
            ->where('school_id', Auth::user()->school_id)
            ->get();
        $student_ids = $studentRecords->pluck('student_id')->toArray();
        $present_students = [];
        $students = SmStudent::whereIn('id', $studentRecords->pluck('student_id')->toArray())->get();
        foreach ($students as $student) {
            $take_exam = SmStudentTakeOnlineExam::where('student_id', $student->id)->where('online_exam_id', $online_exam_question->id)->first();
            if ($take_exam !== '') {
                $present_students[] = $student->id;
            }
        }

        $total_marks = 0;
        foreach ($online_exam_question->assignQuestions as $assignQuestion) {
            $total_marks += $assignQuestion->questionBank->marks;
        }

        return view('backEnd.examination.online_exam_result_view', ['online_exam_question' => $online_exam_question, 'students' => $students, 'present_students' => $present_students, 'total_marks' => $total_marks]);
        /*
        } catch (Exception $exception) {
            Toastr::error('Operation Failed', 'Failed');

            return redirect()->back();
        }
        */
    }

    public function onlineExamQuestionAssign(Request $request)
    {
        /*
        try {
        */
        if ($request->checkbox) {
            $smOnlineExamQuestionAssign = new SmOnlineExamQuestionAssign();
            $smOnlineExamQuestionAssign->online_exam_id = $request->online_exam_id;
            $smOnlineExamQuestionAssign->question_bank_id = $request->questions;
            $smOnlineExamQuestionAssign->school_id = Auth::user()->school_id;
            $smOnlineExamQuestionAssign->academic_id = getAcademicId();
            $smOnlineExamQuestionAssign->save();
        } else {
            SmOnlineExamQuestionAssign::where('question_bank_id', $request->questions)->delete();
            if (checkAdmin() == true) {
                SmOnlineExamQuestionAssign::where('question_bank_id', $request->questions)->delete();
            } else {
                SmOnlineExamQuestionAssign::where('question_bank_id', $request->questions)->where('school_id', Auth::user()->school_id)->delete();
            }
        }

        return response()->json('success');
        /*
        } catch (Exception $exception) {
            Toastr::error('Operation Failed', 'Failed');

            return redirect()->back();
        }
        */
    }

    public function viewOnlineQuestionModal($id)
    {
        /*
        try {
        */
        $question_bank = SmQuestionBank::find($id);

        return view('backEnd.examination.online_eaxm_question_view_modal', ['question_bank' => $question_bank]);
        /*
        } catch (Exception $exception) {
            Toastr::error('Operation Failed', 'Failed');

            return redirect()->back();
        }
        */
    }

    public function onlineExamMarking($exam_id, $s_id)
    {
        $online_exam_info = SmOnlineExam::find($exam_id);
        
        
        /*
        try {
        */
        $online_take_exam_mark = SmStudentTakeOnlineExam::where('online_exam_id', $exam_id)
            ->where('student_id', $s_id)
            ->when(moduleStatusCheck('University'), function ($query) {
                return $query->where('un_academic_id', getAcademicId());
            })
            ->when(! moduleStatusCheck('University'), function ($query) {
                return $query->where('academic_id', getAcademicId());
            })
            ->first();
        
            
        $assign_questions = SmOnlineExamQuestionAssign::where('online_exam_id', $exam_id)->get();
     
        
        $total_mark = 0;
        foreach ($assign_questions as $assign_question) {
            $marks = SmQuestionBank::find($assign_question->question_bank_id)->marks;
            $total_mark += $marks;
        }
    
        if ($online_exam_info->auto_mark == 1) {
            $take_online_exam = SmStudentTakeOnlineExam::where('online_exam_id', $exam_id)->where('student_id', $s_id)
                ->when(moduleStatusCheck('University'), function ($query) {
                    return $query->where('un_academic_id', getAcademicId());
                })
                ->when(! moduleStatusCheck('University'), function ($query) {
                    return $query->where('academic_id', getAcademicId());
                })
                ->first();
            
            return view('backEnd.examination.online_answer_auto_marking', ['take_online_exam' => $take_online_exam, 'online_exam_info' => $online_exam_info, 's_id' => $s_id, 'online_take_exam_mark' => $online_take_exam_mark, 'assign_questions' => $assign_questions, 'total_mark' => $total_mark]);
        }

        $take_online_exam = SmStudentTakeOnlineExam::where('online_exam_id', $exam_id)->where('student_id', $s_id)
            ->when(moduleStatusCheck('University'), function ($query) {
                return $query->where('un_academic_id', getAcademicId());
            })
            ->when(! moduleStatusCheck('University'), function ($query) {
                return $query->where('academic_id', getAcademicId());
            })
            ->first();

        return view('backEnd.examination.online_answer_marking', ['take_online_exam' => $take_online_exam, 'online_exam_info' => $online_exam_info, 's_id' => $s_id, 'online_take_exam_mark' => $online_take_exam_mark, 'assign_questions' => $assign_questions, 'total_mark' => $total_mark]);

        /*
        } catch (Exception $exception) {
            Toastr::error('Operation Failed', 'Failed');

            return redirect()->back();
        }
        */
    }

    public function onlineExamMarkingStore(Request $request)
    {
        /*
        try {
        */
        $exam_questions = SmOnlineExamQuestionAssign::where('online_exam_id', $request->online_exam_id)->get();
        foreach ($exam_questions as $exam_question) {
            $question_id = $exam_question->question_bank_id;
            $trueFalse = 'trueOrFalse_'.$question_id;
            $trueFalse = $request->$trueFalse;
            $suitable_words = 'suitable_words_'.$question_id;
            $suitable_words = $request->$suitable_words;
            $mcq_answer = 'options_'.$question_id;
            $mcq_answer = $request->$mcq_answer;
            $exam_info = SmOnlineExam::find($request->online_exam_id);
            $question_info = SmQuestionBank::find($question_id);
            $question_answer = OnlineExamStudentAnswerMarking::where('online_exam_id', $request->online_exam_id)
                ->where('student_id', $request->student_id)->where('question_id', $question_id)->first();
            if ($question_answer == null) {
                $question_answer = new OnlineExamStudentAnswerMarking();
            }

            $question_answer->online_exam_id = $exam_info->id;
            $question_answer->student_id = $request->student_id;
            $question_answer->question_id = $question_id;
            if ($question_info->type == 'M') {
                $question_answer->user_answer = $mcq_answer;

                $correct_answers = $question_info->questionMu->filter(function ($option): bool {
                    return $option->status == 1;
                })->pluck('id')->map('intval')->toArray();

                $user_answers = is_array($mcq_answer) ? array_map('intval', $mcq_answer) : [(int) $mcq_answer];

                $isCorrect = array_intersect($user_answers, $correct_answers) !== [];
                if ($isCorrect) {
                    $question_answer->answer_status = 1;
                    $question_answer->obtain_marks = $question_info->marks;
                } else {
                    $question_answer->answer_status = 0;
                    $question_answer->obtain_marks = 0;
                }
            }

            if ($question_info->type == 'MI') {
                if ($question_info->answer_type == 'radio') {
                    $question_answer->user_answer = $mcq_answer;
                    $currect_answer = $question_info->questionMu->where('status', 1)->first();
                    if ($mcq_answer !== null && $mcq_answer == $currect_answer->id) {
                        $question_answer->answer_status = 1;
                        $question_answer->obtain_marks = $question_info->marks;
                    } else {
                        $question_answer->answer_status = 0;
                        $question_answer->obtain_marks = 0;
                    }
                } else {
                    $image_answers = OnlineExamStudentAnswerMarking::where('online_exam_id', $request->online_exam_id)
                        ->where('student_id', $request->student_id)->where('question_id', $question_id)->get();
                    $student_answers = [];
                    foreach ($image_answers as $value) {
                        $student_answers[] = (int) $value->user_answer;
                    }

                    $question_answers = [];
                    foreach ($question_info->questionMu as $value) {
                        if ($value->status == 1) {
                            $question_answers[] = $value->id;
                        }
                    }

                    sort($student_answers);
                    sort($question_answers);
                    if ($student_answers == $question_answers) {
                        $question_answer->answer_status = 1;
                        $question_answer->obtain_marks = $question_info->marks;
                    } else {
                        $question_answer->answer_status = 0;
                        $question_answer->obtain_marks = 0;
                    }
                }
            }

            if ($question_info->type == 'T') {
                $question_answer->user_answer = $trueFalse;
                $currect_answer = $question_info->trueFalse;
                if ($trueFalse !== null && $trueFalse == $currect_answer) {
                    $question_answer->answer_status = 1;
                    $question_answer->obtain_marks = $question_info->marks;
                } else {
                    $question_answer->answer_status = 0;
                    $question_answer->obtain_marks = 0;
                }
            }

            if ($question_info->type == 'F') {
                $question_answer->user_answer = $suitable_words;
                $currect_answer = $question_info->suitable_words;
                if ($suitable_words !== null && in_array($question_id, $request->marks)) {
                    $question_answer->answer_status = 1;
                    $question_answer->obtain_marks = $question_info->marks;
                } else {
                    $question_answer->answer_status = 0;
                    $question_answer->obtain_marks = 0;
                }
            }

            $question_answer->school_id = Auth::user()->school_id;
            $question_answer->marked_by = Auth::user()->id;
            $question_answer->save();
        }

        $total_obtain_marks = OnlineExamStudentAnswerMarking::where('online_exam_id', $request->online_exam_id)
            ->where('student_id', $request->student_id)->sum('obtain_marks');
        $online_take_exam_mark = SmStudentTakeOnlineExam::where('online_exam_id', $request->online_exam_id)->where('student_id', $request->student_id)->where('academic_id', getAcademicId())->first();
        $online_take_exam_mark->total_marks = $total_obtain_marks;
        $online_take_exam_mark->status = 2;
        $online_take_exam_mark->save();
        $wrong = OnlineExamStudentAnswerMarking::where('user_answer', '=', '')->delete();

        $studentInfo = SmStudent::find($request->student_id);
        $data['class'] = $studentInfo->studentRecord->class->class_name;
        $data['section'] = $studentInfo->studentRecord->section->section_name;
        $data['subject'] = $exam_info->subject->subject_name;
        $data['online_exam'] = $exam_info->title;
        $records = $this->studentRecordInfo($studentInfo->studentRecord->class_id, $studentInfo->studentRecord->section_id)->pluck('studentDetail.user_id');
        $this->sent_notifications('Online_Exam_Result', $records, $data, ['Student', 'Parent']);

        Toastr::success('Operation successful', 'Success');

        return redirect('online-exam-marks-register/'.$request->online_exam_id);
        /*
        } catch (Exception $exception) {
            Toastr::error('Operation Failed', 'Failed');

            return redirect()->back();
        }
        */
    }

    public function onlineExamReport(Request $request)
    {
        /*
        try {
        */
        if (moduleStatusCheck('OnlineExam') == true) {
            $exams = InfixOnlineExam::where('active_status', 1)
                ->where('academic_id', getAcademicId())
                ->where('school_id', Auth::user()->school_id)
                ->get(['id', 'title']);
        } else {
            $exams = SmOnlineExam::get(['id', 'title']);
        }

        $classes = SmClass::get(['id', 'class_name']);

        return view('backEnd.reports.online_exam_report', ['exams' => $exams, 'classes' => $classes]);
        /*
        } catch (Exception $exception) {
            Toastr::error('Operation Failed', 'Failed');

            return redirect()->back();
        }
        */
    }

    public function universityOnlineExamReportSearch($request)
    {
        $this->validate($request, [
            'exam' => 'required',
            'un_semester_label_id' => 'required',
            'un_section_id' => 'required',
        ]);
        /*
        try {
        */
        date_default_timezone_set($this->timeZone);
        $present_date_time = date('Y-m-d H:i:s');
        $student_ids = SmStudentReportController::SemesterLabelSectionStudent($request);
        $students = SmStudent::whereIn('id', $student_ids)->where('school_id', Auth::user()->school_id)->get();
        if ($students->count() == 0) {
            Toastr::error('No Result Found', 'Failed');

            return redirect('online-exam-report');
        }

        if (moduleStatusCheck('OnlineExam') == true) {
            $online_exam_question = InfixOnlineExam::find($request->exam);
            $online_exam = InfixOnlineExam::where('class_id', $request->class)->where('section_id', $request->section)->where('id', $request->exam)->where('end_date_time', '<', $present_date_time)->where('status', 1)->first();
            $present_students = [];
            foreach ($students as $student) {
                $take_exam = InfixStudentTakeOnlineExam::where('student_id', $student->id)->where('online_exam_id', $online_exam_question->id)->first();
                if ($take_exam !== '') {
                    $present_students[] = $student->id;
                }
            }

            $total_marks = 0;
            foreach ($online_exam_question->assignQuestions as $assignQuestion) {
                $total_marks += $assignQuestion->questionBank->marks;
            }

            $exams = InfixOnlineExam::where('active_status', 1)->where('academic_id', getAcademicId())->where('school_id', Auth::user()->school_id)->get();
        } else {
            $online_exam_question = SmOnlineExam::find($request->exam);
            $online_exam = SmOnlineExam::where('un_semester_label_id', $request->un_semester_label_id)->where('un_section_id', $request->un_section_id)->where('id', $request->exam)
                ->where('end_date_time', '<', $present_date_time)->where('status', 1)->first();
            $present_students = [];
            foreach ($students as $student) {
                $take_exam = SmStudentTakeOnlineExam::where('student_id', $student->id)->where('online_exam_id', $online_exam_question->id)->first();
                if ($take_exam !== '') {
                    $present_students[] = $student->id;
                }
            }

            $total_marks = 0;
            foreach ($online_exam_question->assignQuestions as $assignQuestion) {
                $total_marks += $assignQuestion->questionBank->marks;
            }

            $exams = SmOnlineExam::where('active_status', 1)->where('un_academic_id', getAcademicId())->where('school_id', Auth::user()->school_id)->get();
        }

        $exam_id = $request->exam;

        return view('backEnd.reports.online_exam_report', ['online_exam_question' => $online_exam_question, 'students' => $students, 'present_students' => $present_students, 'total_marks' => $total_marks, 'exams' => $exams, 'exam_id' => $exam_id]);
        /*
        } catch (Exception $exception) {
            Toastr::error('Operation Failed', 'Failed');

            return redirect()->back();
        }
        */
    }

    public function onlineExamReportSearch(Request $request)
    {
        if (moduleStatusCheck('University')) {
            return $this->universityOnlineExamReportSearch($request);
        }

        $this->validate($request, [
            'exam' => 'required',
            'class' => 'required',
            'section' => 'required',
        ]);
        
            $user = Auth::user();
            date_default_timezone_set('Asia/Dhaka');
            $present_date_time = date('Y-m-d H:i:s');
            $student_ids = SmStudentReportController::classSectionStudent($request);
            $students = SmStudent::whereIn('id', $student_ids)->where('academic_id', getAcademicId())
                                                                ->where('school_id', $user->school_id)
                                                                ->get();
           

            

            if (moduleStatusCheck('OnlineExam')) {
                $online_exam_question = InfixOnlineExam::find($request->exam);
                
                $present_students = [];
                foreach ($students as $student) {
                    $take_exam = InfixStudentTakeOnlineExam::where('student_id', $student->id)->where('online_exam_id', $online_exam_question->id)->first();
                    if ($take_exam !== '') {
                        $present_students[] = $student->id;
                    }
                }

                $total_marks = 0;
                foreach ($online_exam_question->assignQuestions as $assignQuestion) {
                    $total_marks += $assignQuestion->questionBank->marks;
                }

                $exams = InfixOnlineExam::where('active_status', 1)->where('academic_id', getAcademicId())->where('school_id', $user->school_id)->get();
            } else {
                $online_exam_question = SmOnlineExam::find($request->exam);
                $online_exam = SmOnlineExam::where('class_id', $request->class)
                            ->where('section_id', $request->section)
                            ->when(shiftEnable(), function ($query) use ($request) {
                                return $query->where('shift_id', $request->shift);
                            })
                            ->where('id', $request->exam)
                            ->where('end_date_time', '<', $present_date_time)
                            ->where('status', 1)
                            ->first();
                $present_students = [];
                foreach ($students as $student) {
                    $take_exam = SmStudentTakeOnlineExam::where('student_id', $student->id)->where('online_exam_id', $online_exam_question->id)->first();
                    if ($take_exam !== '') {
                        $present_students[] = $student->id;
                    }
                }

                $total_marks = 0;
                foreach ($online_exam_question->assignQuestions as $assignQuestion) {
                    $total_marks += $assignQuestion->questionBank->marks;
                }

                $exams = SmOnlineExam::where('active_status', 1)->where('academic_id', getAcademicId())->where('school_id', $user->school_id)->get();
            }

            if ($students->count() == 0 && empty($online_exam)) {
                Toastr::error('No Result Found', 'Failed');
                return redirect('online-exam-report');
            }

            if (teacherAccess()) {
                $teacher_info = SmStaff::where('user_id', $user->id)->first();
                $classes = $teacher_info->classes;
            } else {
                $classes = SmClass::get(['id', 'class_name']);
            }

            $class_id = $request->class;
            $section_id = $request->section;
            $shift_id= shiftEnable() ? $request->shift : '';
            $exam_id = $request->exam;
            $clas = SmClass::find($request->class);
            $sec = SmSection::find($request->section);
            $shift = null;

            if (shiftEnable() && !empty($request->shift)) {
                $shift = Shift::find($request->shift);
            }

            return view('backEnd.reports.online_exam_report', ['online_exam_question' => $online_exam_question, 'students' => $students, 'present_students' => $present_students, 'total_marks' => $total_marks, 'exams' => $exams, 'classes' => $classes, 'class_id' => $class_id, 'exam_id' => $exam_id, 'section_id' => $section_id, 'clas' => $clas, 'sec' => $sec, 'shift_id' => $shift_id, 'shift' => $shift]);
        
       
        
    }

    public function onlineExamDatatable()
    {
        /*
        try {
        */
        if (teacherAccess()) {
            $teacher_info = SmStaff::where('user_id', Auth::user()->id)->first();
            $online_exams = SmOnlineExam::query();
            $online_exams->where('status', '!=', 2)
                ->join('sm_assign_subjects', 'sm_assign_subjects.subject_id', '=', 'sm_online_exams.subject_id')
                ->where('sm_assign_subjects.teacher_id', $teacher_info->id)
                ->where('sm_online_exams.academic_id', getAcademicId())
                ->where('sm_online_exams.school_id', Auth::user()->school_id)
                ->select('sm_online_exams.*')
                ->distinct('id');
        } else {
            $online_exams = SmOnlineExam::query();
            $online_exams->with('class', 'section', 'subject','shift')->where('status', '!=', 2);
        }

        return DataTables::of($online_exams)
            ->addIndexColumn()
            ->addColumn('class_section', function ($row): string {
                if (moduleStatusCheck('University')) {
                    return ($row->unSemesterLabel !== '' && $row->section !== '') ? $row->unSemesterLabel->name.'('.$row->section->section_name.')' : '';
                }

                if(shiftEnable()){
                    return ($row->class != '' && $row->section != '') ? $row->class->class_name . '(' . $row->section->section_name . ') ['.@$row->shift->shift_name.']' : '';
                }else{
                    return ($row->class != '' && $row->section != '') ? $row->class->class_name . '(' . $row->section->section_name . ')' : '';
                }
            })
            ->addColumn('subject_name', function ($row) {
                return ($row->subject !== '') ? $row->subject->subject_name : '';
            })
            ->addColumn('exam_time', function ($row): string {
                return (($row->date !== 'NULL') ? dateConvert($row->date) : '').'<br>'.__('exam.time').':'.date('h:i A', strtotime($row->start_time)).'-'.(($row->end_date_time !== 'NULL') ? date('h:i A', strtotime($row->end_date_time)) : 'Unlimited');
            })
            ->addColumn('duration', function ($row): string {
                $totalDuration = !is_null($row->end_time)    ? Carbon::parse($row->start_time)->diffInMinutes(Carbon::parse($row->end_time)) : 0;
                $duration =  ($row->end_time != 'NULL') ? gmdate($totalDuration) : 'UnlimitedMin';
                return $totalDuration;
            })
            ->addColumn('status_button', function ($row): string {
                if ($row->status == 0) {
                    return '<button class="primary-btn small bg-warning text-white border-0">'.__('common.pending').'</button>';
                }

                return '<button class="primary-btn small bg-success text-white border-0">'.__('exam.published').'</button>';
            })
            ->addColumn('action', function ($row): string {
                $view = view('backEnd.examination.online_exam_action', ['row' => $row]);

                return (string) $view;
            })
            ->rawColumns(['status_button', 'exam_time', 'action', 'date'])
            ->make(true);

    }
}
