<?php

namespace App\Http\Controllers\api;

use App\ApiBaseMethod;
use App\Http\Controllers\Controller;
use App\SmStaff;
use App\SmStaffAttendence;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class ApiSmStaffAttendanceController extends Controller
{
    public function teacherMyAttendanceSearchAPI(Request $request, $id = null)
    {

        $input = $request->all();

        $validator = Validator::make($input, [
            'month' => 'required',
            'year' => 'required',
        ]);

        if ($validator->fails()) {
            if (ApiBaseMethod::checkUrl($request->fullUrl())) {
                return ApiBaseMethod::sendError('Validation Error.', $validator->errors());
            }

            return redirect()->back()->withErrors($validator)->withInput();
        }

        try {
            $teacher = SmStaff::where('user_id', $id)->first();

            $year = $request->year;
            $month = $request->month;
            if ($month < 10) {
                $month = '0'.$month;
            }

            $current_day = date('d');

            $days = cal_days_in_month(CAL_GREGORIAN, $month, $request->year);
            $days2 = '';
            if ($month !== 1) {
                $days2 = cal_days_in_month(CAL_GREGORIAN, $month - 1, $request->year);
            } else {
                $days2 = cal_days_in_month(CAL_GREGORIAN, $month, $request->year);
            }

            if ($month !== 1) {
                $previous_month = $month - 1;
                $previous_date = $year.'-'.$previous_month.'-'.$days2;
            } else {
                $previous_month = 12;
                $previous_date = $year - 1 .'-'.$previous_month.'-'.$days2;
            }

            $previousMonthDetails['date'] = $previous_date;
            $previousMonthDetails['day'] = $days2;
            $previousMonthDetails['week_name'] = date('D', strtotime($previous_date));

            $attendances = SmStaffAttendence::where('staff_id', $teacher->id)
                ->where('attendence_date', 'like', '%'.$request->year.'-'.$month.'%')
                ->select('attendence_type as attendance_type', 'attendence_date as attendance_date')
                ->get();

            if (ApiBaseMethod::checkUrl($request->fullUrl())) {
                $data['attendances'] = $attendances;
                $data['previousMonthDetails'] = $previousMonthDetails;
                $data['days'] = $days;
                $data['year'] = $year;
                $data['month'] = $month;
                $data['current_day'] = $current_day;
                $data['status'] = 'Present: P, Late: L, Absent: A, Holiday: H, Half Day: F';

                return ApiBaseMethod::sendResponse($data, null);
            }
        } catch (Exception $exception) {
            return ApiBaseMethod::sendError('Error.', $exception->getMessage());
        }

        return null;
    }

    public function saas_teacherMyAttendanceSearchAPI(Request $request, $school_id, $id = null)
    {

        $input = $request->all();

        $validator = Validator::make($input, [
            'month' => 'required',
            'year' => 'required',
        ]);

        if ($validator->fails()) {
            if (ApiBaseMethod::checkUrl($request->fullUrl())) {
                return ApiBaseMethod::sendError('Validation Error.', $validator->errors());
            }

            return redirect()->back()->withErrors($validator)->withInput();
        }

        try {
            $teacher = SmStaff::where('user_id', $id)->where('school_id', $school_id)->first();

            $year = $request->year;
            $month = $request->month;
            if ($month < 10) {
                $month = '0'.$month;
            }

            $current_day = date('d');

            $days = cal_days_in_month(CAL_GREGORIAN, $month, $request->year);
            $days2 = '';
            if ($month !== 1) {
                $days2 = cal_days_in_month(CAL_GREGORIAN, $month - 1, $request->year);
            } else {
                $days2 = cal_days_in_month(CAL_GREGORIAN, $month, $request->year);
            }

            if ($month !== 1) {
                $previous_month = $month - 1;
                $previous_date = $year.'-'.$previous_month.'-'.$days2;
            } else {
                $previous_month = 12;
                $previous_date = $year - 1 .'-'.$previous_month.'-'.$days2;
            }

            $previousMonthDetails['date'] = $previous_date;
            $previousMonthDetails['day'] = $days2;
            $previousMonthDetails['week_name'] = date('D', strtotime($previous_date));

            $attendances = SmStaffAttendence::where('staff_id', $teacher->id)
                ->where('attendence_date', 'like', '%'.$request->year.'-'.$month.'%')
                ->select('attendence_type as attendance_type', 'attendence_date as attendance_date')
                ->where('school_id', $school_id)->get();

            if (ApiBaseMethod::checkUrl($request->fullUrl())) {
                $data['attendances'] = $attendances;
                $data['previousMonthDetails'] = $previousMonthDetails;
                $data['days'] = $days;
                $data['year'] = $year;
                $data['month'] = $month;
                $data['current_day'] = $current_day;
                $data['status'] = 'Present: P, Late: L, Absent: A, Holiday: H, Half Day: F';

                return ApiBaseMethod::sendResponse($data, null);
            }
        } catch (Exception $exception) {
            return ApiBaseMethod::sendError('Error.', $exception->getMessage());
        }

        return null;
    }
}
